#ifndef SOLVERS_H
#define SOLVERS_H

#include "../common/structs.h"
#include "../common/vector.h"
#include <time.h>

vector* simple_pos(vector *p, vector *v, vector *a, double t);
vector* simple_velocity(vector *v, vector *a, double t);
vector* simple_acceleration(vector *a, double t);
void run_euler(void* (*calc_acceleration) (state *new_state, state *old_state), 
			   state *old_state);
void run_midpoint(void* (*calc_acceleration) (state *new_state, state *old_state), 
				  state *old_state);
void run_rk4(void* (*calc_acceleration) (state *new_state, state *old_state), 
			 state *old_state);
void run_simulation();

#define EXPLICIT 0
#define EULER 1
#define MIDPOINT 2
#define RK4 3

#endif /* SOLVERS_H */
